/*
 * tbutton.h
 *
 * Copyright (C) 1995, 1996, 1997, 1997, 1998, 1999, 2000, 2001, 2002 Kenichi Kourai
 * Copyright (C) 1999, 2000, 2001, 2002 Luiz Blanes
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with blwm; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _TBUTTON_H_
#define _TBUTTON_H_

#include "button.h"

class BlImage;
class Blwm;

/*
 * TaskbarButton
 */
class TaskbarButton : public Button {
private:
  BlImage* img;                    // image of the left side
  char* shortname;                 // short title fitted to button size
  Bool focus;
  Blwm* blWm;                      // ptr to corresponding blwm

protected:
  char* name;                      // taskbar button title
  static const int TB_MARGIN = 4;

public:
  static Rect rcTButton;           // the size of taskbar button at that time
  static XFontSet* fsb;            // ref to bold font set
  static BlImage* imgTile;

  static const int SYMBOL_SIZE = 16;	// pixmap size
  static int BUTTON_HEIGHT;		// tbutton height

private:
  virtual void FillBackground();
  virtual void DrawName();

public:
  TaskbarButton(Blwm* blwm, const Rect& rc, BlImage* image);
  ~TaskbarButton();

  void ChangeName();
  void CalcShortName();
  Bool CheckFocus() const { return focus; }
  void SetFocus() { focus = True; }
  void ResetFocus() { focus = False; }
  BlImage* GetImage() const { return img; }
  void SetImage(BlImage* image);
  void MoveResizeButton(const Rect& rect);

  virtual void DrawButton();
  virtual void MapButton();
  virtual void UnmapButton();
  virtual void ExecButtonFunc(ButtonState bs);
  virtual void Button1Press();
  virtual void Button3Release(const Point& ptRoot);
  virtual void Enter();

  static void Initialize();
};

#endif // _TBUTTON_H_
