/*
 * switcher.h
 *
 * Copyright (C) 1995, 1996, 1997, 1997, 1998, 1999, 2000, 2001, 2002 Kenichi Kourai
 * Copyright (C) 1999, 2000, 2001, 2002 Luiz Blanes
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with blwm; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _SWITCH_H_
#define _SWITCH_H_

#include "misc.h"
#include "list.h"

class Blwm;
class Timer;
class BlImage;

/*
 * TaskSwitcher class
 */
class TaskSwitcher {
private:
  Window frame;
  Window titleFrame;               // title name window included frame
  Window title;                    // title name window excluded frame
  Rect rc;

  // don't use these iterator for the other purposes
  List<Blwm>::Iterator* iterMap;   // iterator to search next mapped window
  List<Blwm>::Iterator* iterUnmap; // iterator to search next unmapped window
  Bool LookMapList;                // flag for looking in iterMap or iterUnmap

  Bool direct;  // forward if True

  BlImage* imgSwitcher;
  BlImage* imgTitle;

  static const int BASE_WIDTH = 350;
  static const int BASE_HEIGHT = 62;
  static const int TITLE_WIDTH = 322;
  static const int TITLE_HEIGHT = 24;

public:
  static Timer* swTimer;

private:
  void MapSwitcher(int winNum);
  void EventLoop(int winNum, KeyCode code, unsigned int mod);

  Blwm* GetFirstFocus();
  Blwm* GetNextFocus();
  Blwm* GetPrevFocus();

  void DrawTaskSwitcher();
  void DrawTitle(const char* name);
  void DrawRect(int focusWin, int winNum);
  void DrawPixmaps(int winNum);
  void DrawPixmap(Blwm* blWm, int num, int base);

public:
  TaskSwitcher();
  ~TaskSwitcher();

  void SwitchTask(Bool forward, KeyCode code, unsigned int mod);

  static void Initialize();
};

#endif // SWITCH_H
