/*
 * startmenu.h
 *
 * Copyright (C) 1995, 1996, 1997, 1997, 1998, 1999, 2000, 2001, 2002 Kenichi Kourai
 * Copyright (C) 1999, 2000, 2001, 2002 Luiz Blanes
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with blwm; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _STARTMENU_H_
#define _STARTMENU_H_

#include "menu.h"

class BlImage;

class StartMenu : public Menu {
private:
  Window logo;                      // window for logo mark in the left side
  Window* itemFocus;                // transparent window for each item
                                    // this includes the parts of logo.
private:
  static BlImage* imgLogoMark;           // logo mark
  static BlImage* imgStart[2];
  
  static const int LOGO_WIDTH = 21;

public:
  StartMenu(MenuElem* mItem);
  ~StartMenu();
  void MapMenu();
  void UnmapMenu();
  void DrawMenu(Window win);
  int FindItem(Window win);
  void ExecFunction(FuncNumber fn, int num);

  static void Initialize();
};

#endif // _STARTMENU_H_
