/*
 * fbutton.h
 *
 * Copyright (C) 1995, 1996, 1997, 1997, 1998, 1999, 2000, 2001, 2002 Kenichi Kourai
 * Copyright (C) 1999, 2000, 2001, 2002 Luiz Blanes
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with blwm; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _FBUTTON_H_
#define _FBUTTON_H_

#include "button.h"

class Blwm;
class BlImage;

/*
 * FrameButton class
 */
class FrameButton : public Button {
protected:
  BlImage* img;
  Blwm* blWm;             // pointer to Blwm that this button belong to

  static BlImage* imgButton[4];
  static char* desc[4];

  static const int BUTTON_WIDTH = 12;
  static const int BUTTON_HEIGHT = 10;

public:
  // Frame button name
  enum ButtonName { MINIMIZE, MAXIMIZE, CLOSE, RESTORE };

public:
  FrameButton(Blwm* blwm, Window parent, const Rect& rc);
  virtual ~FrameButton();

  void ChangeImage(ButtonName bn);
  void DrawButton();
  virtual void ExecButtonFunc(ButtonState bs) = 0;
  void Button1Press();

  static void Initialize();
};

class FrameButton1 : public FrameButton {
public:
  FrameButton1(Blwm* blWm, Window parent, const Rect& rc)
    : FrameButton(blWm, parent, rc) {}

  void ExecButtonFunc(ButtonState bs);
};

class FrameButton2 : public FrameButton {
public:
  FrameButton2(Blwm* blWm, Window parent, const Rect& rc)
    : FrameButton(blWm, parent, rc) {}
  void ExecButtonFunc(ButtonState bs);
};

class FrameButton3 : public FrameButton {
public:
  FrameButton3(Blwm* blWm, Window parent, const Rect& rc)
    : FrameButton(blWm, parent, rc) {}
  void ExecButtonFunc(ButtonState bs);
};

#endif // _FBUTTON_H_
