/*
 * colormap.cc
 *
 * Copyright (C) 1995, 1996, 1997, 1997, 1998, 1999, 2000, 2001, 2002 Kenichi Kourai
 * Copyright (C) 1999, 2000, 2001, 2002 Luiz Blanes
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with blwm; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "main.h"
#include "misc.h"
#include "blwm.h"
#include "util.h"
#include "desktop.h"

void Blwm::ChangeColormap(const XColormapEvent& ev)
{
  XWindowAttributes attr;
  Bool reInstall = False;
  XEvent xev;
  Blwm* blWm;

  if (ev.c_new) {
    XGetWindowAttributes(display, ev.window, &attr);
    if (this == desktop.GetCmapInstalled() && GetNumCmapWins() == 0)
      desktop.SetCurrentCmap(attr.colormap);
    reInstall = True;
  }
  else if (ev.state == ColormapUninstalled &&
	   desktop.GetCurrentCmap() == ev.colormap)
    reInstall = True;
  
  while (XCheckTypedEvent(display, ColormapNotify, &xev)) {
    XColormapEvent* cev = (XColormapEvent *)&xev;

    if (XFindContext(display, cev->window, Blwm::context, (caddr_t *)&blWm)
	== XCSUCCESS) {
      ASSERT(blWm);

      if (cev->c_new) {
	XGetWindowAttributes(display, blWm->GetWin(), &attr);
	if (blWm == desktop.GetCmapInstalled() && blWm->GetNumCmapWins() == 0)
	  desktop.SetCurrentCmap(attr.colormap);
	reInstall = True;
      }
      else if (cev->state == ColormapUninstalled &&
	       desktop.GetCurrentCmap() == cev->colormap)
	reInstall = False;
    }
  }
  
  if (reInstall) {
    if (desktop.GetCurrentCmap()) {
      XSync(display, 0); /* XXX */
      XInstallColormap(display, desktop.GetCurrentCmap());
    }
#ifdef DEBUG
    else
      printf("curCmap is None\n");
#endif
  }
}

/*
 * InstallWindowColormaps --
 *   Install window colormap.
 */
void Blwm::InstallWindowColormaps()
{
  XWindowAttributes attr;
  Bool isThisWin = False;

  desktop.SetCmapInstalled(this);

  if (nCmapWins > 0) {
    for (int i = nCmapWins - 1; i >= 0; i--) {
      if (cmapWins[i] == wOrig)
	isThisWin = True;
      XGetWindowAttributes(display, cmapWins[i], &attr);

      if (desktop.GetCurrentCmap() != attr.colormap) {
	desktop.SetCurrentCmap(attr.colormap);
	XInstallColormap(display, attr.colormap);
      }
    }
  }
  
  if (!isThisWin) {
    XGetWindowAttributes(display, wOrig, &attr);
    if (desktop.GetCurrentCmap() != attr.colormap) {
      desktop.SetCurrentCmap(attr.colormap);
      XInstallColormap(display, attr.colormap);
    }
  }
}

/*
 * FetchWMColormapWindows --
 *
 */
void Blwm::FetchWMColormapWindows()
{
  if(XGetWMColormapWindows(display, wOrig, &cmapWins, &nCmapWins) == 0) {
    cmapWins = NULL;
    nCmapWins = 0;
  }
}
