/*
 * blwmrc.cc
 *
 * Copyright (C) 1995, 1996, 1997, 1997, 1998, 1999, 2000, 2001, 2002 Kenichi Kourai
 * Copyright (C) 1999, 2000, 2001, 2002 Luiz Blanes
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with blwm; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include "main.h"
#include "taskbar.h"
#include "util.h"
#include "parse.h"
#include "blwmrc.h"
#include "blwm.h"
#include "key.h"
#include "desktop.h"

/*
 * Default values
 */
int DoubleClickTime		    = 500;
int DoubleClickRange		    = 5;
Bool TitlebarMotion		    = True;
int TitlebarMotionSpeed		    = 8;
int MenuDelayTime		    = 300;
int MenuDelayTime2		    = 300;
int PagingMovement		    = 100;
Point TopLeftPage		    = Point(0, 0);
Dim PagingSize			    = Dim(1, 1);
int PagingSpeed                     = 10;
InternGeom PagerGeometry	    = InternGeom(0, 0, 48, 48, Point(0, 0));
int EdgeResistance                  = 50;
int SnappingMove                    = 5;
int SnappingEdges		    = 5;
Bool NoResizeOverTaskbar            = False;
Bool SmartPlacement		    = False;
Bool UseTaskbar                     = True;
Taskbar::TaskbarPos TaskbarPosition = Taskbar::BOTTOM;
unsigned int TaskbarRows	    = 1;
Bool OnTopTaskbar                   = True;
char* WallPaper			    = "Windows98";
char* LocaleName		    = "pt_BR";
Bool UseBoldFont		    = False;
Bool UseExitDialog		    = False;
Bool UseConfirmDialog               = False;
Bool UsePager			    = False;
Bool OpaqueMove			    = True;
Bool OpaqueResize                   = True;
Bool FullOpaque                     = True;
Bool ClickToFocus		    = True;
Bool FocusOnMap                     = False;
Bool ClickingRaises                 = True;
Bool NoDesktopFocus		    = False;
Bool AutoRaise			    = False;
Bool UseClock			    = True;
char* ClockLocaleName		    = NULL;
int AutoRaiseDelay		    = 100;
char* ImagePath		            = IMGDIR;
Bool TaskbarAutoHide                = False;
Bool RestoreMinimize                = False;
Bool RestartOnFailure               = True;
Bool GradMenuMap                    = True;
int GradMenuMapSpeed                = 3;
Bool GradTaskbarMotion              = True;
int GradTaskbarMotionSpeed          = 6;
Bool GradTitlebar                   = True;
int GradTitlebarColors              = 50;
Bool OnTopPager                     = False;
double ShiftMoveRatio               = 1.0;
double CtrlMoveRatio                = 1.0;
int HourGlassTime                   = 1000;
int UseInfoDisplay                  = False;
Blwm::GradStyle GradWindowMapStyle  = Blwm::Normal; 
int GradWindowMapSpeed              = 10;
Bool UseDebugger                    = True;
int TooltipDelayTime                = 300;
int TooltipMotionSpeed              = 7;
int TooltipDisplayTime              = 8000;
unsigned int NoFocusChangeMask      = ShiftMask;
int TaskbarShowDelay                = 0;
int TaskbarHideDelay                = 500;
Bool TaskbarButtonInScr             = False;
Bool AllowRemoteCmd                 = False;
Bool DisableDesktopChange           = False;

/*
 * Default message catalogs
 */
char* StartButtonTitle		    = "Iniciar";
char* StartButtonMessage            = "Clique aqui para iniciar o Blanes 2000.";
char* MinimizeButtonMessage         = "Minimizar";
char* MaximizeButtonMessage         = "Maximizar";
char* CloseButtonMessage            = "Fechar";
char* RestoreButtonMessage          = "Restaurar";
char* ClockFormat		    = "%R";
char* ClockMessageFormat            = "%A, %e %B de %Y";

/*
 * Default sizes
 */
int IconSize			    = 32;
int FrameTitleHeight                = Blwm::BUTTON_HEIGHT + 4;
int FrameBorderWidth                = 2;
int TaskbarButtonHeight             = 22;
int IndicatorSize                   = 16;
int IconVerticalSpacing             = 43;
int IconHorizontalSpacing           = 43;

/*
 * Images
 */
char* TitlebarImage                 = NULL;
char* TitlebarActiveImage           = NULL;
char* FrameImage                    = NULL;
char* FrameActiveImage              = NULL;
char* TaskbarImage                  = NULL;
char* MenuImage                     = NULL;
char* MenuActiveImage               = NULL;
char* PagerImage                    = NULL;
char* DialogImage                   = NULL;
char* SwitcherImage                 = NULL;
char* StartMenuLogoImage            = NULL;

/*
 * Default icons
 */
char* DefaultIcon                   = NULL;
char* DefaultLargeIcon              = NULL;
char* DefaultShortcutIcon           = NULL;

/*
 * Default colors
 */
XColor IconForeColor;		// black
XColor IconBackColor;		// white
XColor IconStringColor;		// white
XColor IconStringActiveColor;	// white
XColor MiniatureColor;		// black
XColor MiniatureActiveColor;	// white
XColor TitlebarColor;		// darkGray
XColor TitlebarColor2;		// grey (not gray!)
XColor TitlebarActiveColor;	// blue
XColor TitlebarActiveColor2;	// lightBlue
XColor TitleStringColor;	// gray
XColor TitleStringActiveColor;	// white
XColor MenuColor;		// gray
XColor MenuActiveColor;		// blue
XColor MenuStringColor;		// black
XColor MenuStringActiveColor;	// white
XColor DialogColor;		// gray
XColor DialogStringColor;	// black
XColor SwitcherColor;		// gray
XColor SwitcherActiveColor;	// blue
XColor SwitcherStringColor;	// black
XColor FrameColor;		// gray
XColor FrameActiveColor;	// gray
XColor PagerColor;		// gray
XColor PagerActiveColor;	// darkGray
XColor ButtonColor;		// gray
XColor ButtonActiveColor;	// gray
XColor ButtonStringColor;	// black
XColor ButtonStringActiveColor;	// black
XColor TaskbarColor;		// gray
XColor ClockStringColor;	// black
XColor DesktopColor;		// blue
XColor DesktopActiveColor;	// blue
XColor StartMenuLogoColor;	// blue
XColor CursorColor;		// white
XColor TooltipColor;		// yellow
XColor TooltipStringColor;	// black

/*
 * Default fonts
 */
char* DefaultFont                   = "-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*";
char* TitleFont			    = "-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*";
char* TaskbarFont		    = "-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*";
char* TaskbarBoldFont		    = "-*-*-bold-r-normal-*-14-*-*-*-*-*-*-*";
char* CascadeMenuFont		    = "-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*";
char* CtrlMenuFont		    = "-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*";
char* StartMenuFont		    = "-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*";
char* IconFont			    = "-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*";
char* DialogFont		    = "-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*";

/*
 * Default start menu
 */
MenuElem StartMenuTemplate[] =
  {{"Sair do Blanes 2000   ", "exit.xpm", Q_EXIT, "", -1, -1, NULL, NULL}};

/*
 * Default control menu
 */
MenuElem CtrlMenuTemplate[] =
  {{"Restaurar      ", "", Q_RESTORE,   "", -1, -1, &CtrlMenuTemplate[1], NULL},
   {"Mover",          "", Q_MOVE,      "", -1, -1, &CtrlMenuTemplate[2], NULL},
   {"Redimensionar",        "", Q_RESIZE,    "", -1, -1, &CtrlMenuTemplate[3], NULL},
   {"Minimizar",      "", Q_MINIMIZE,  "", -1, -1, &CtrlMenuTemplate[4], NULL},
   {"Maximizar",      "", Q_MAXIMIZE,  "", -1, -1, &CtrlMenuTemplate[5], NULL},
   {"",              "", Q_SEPARATOR, "", -1, -1, &CtrlMenuTemplate[6], NULL},
   {"Fechar",         "", Q_CLOSE,     "", -1, -1, &CtrlMenuTemplate[7], NULL},
   {"Matar",          "", Q_KILL,      "", -1, -1, NULL,                 NULL}};

MenuElem DesktopMenuTemplate[] =
  {{"(None) ", "", Q_NONE, "", -1, -1, NULL, NULL}};

MenuElem IconMenuTemplate[] =
  {{"Executar", "", Q_EXEC_ICON, "", -1, -1, &IconMenuTemplate[1], NULL},
   {"Deletar",  "", Q_DELETE_ICON,  "", -1, -1, NULL, NULL}};

MenuElem TaskbarMenuTemplate[] =
  {{"(None) ", "", Q_NONE, "", -1, -1, NULL, NULL}};

MenuElem ExitDlgTemplate[] =
  {{"StaticText", "O que deseja fazer ?", Q_NONE, "", -1, -1,
    &ExitDlgTemplate[1], NULL},
   {"RadioButton", "Sair do Blanes 2000.", Q_EXIT, "", -1, -1,
    &ExitDlgTemplate[2], NULL},
   {"RadioButton", "Reiniciar o Blanes 2000.", Q_RESTART, "", -1, -1,
    &ExitDlgTemplate[3], NULL},
   {"IconPixmap", "exit2.xpm", Q_NONE, "", -1, -1,
    &ExitDlgTemplate[4], NULL},
   {"OKButton",	"Sim", Q_NONE, "", -1, -1,
    &ExitDlgTemplate[5], NULL},
   {"CancelButton", "Nao", Q_NONE, "", -1, -1,
    &ExitDlgTemplate[6], NULL},
   {"HelpButton", "Ajuda", Q_NONE, "", -1, -1,
    NULL, NULL}};

SCKeyEntry scMenuKey[] =
  {{XK_Escape,   0,           Q_POPDOWN_MENU},
   {XK_Alt_L,    0,           Q_POPDOWN_ALL_MENU},
   {XK_Alt_R,    0,           Q_POPDOWN_ALL_MENU},
   {XK_Meta_L,   0,           Q_POPDOWN_ALL_MENU},
   {XK_Meta_R,   0,           Q_POPDOWN_ALL_MENU},
   {XK_Up,       0,           Q_UP_FOCUS},
   {XK_Down,     0,           Q_DOWN_FOCUS},
   {XK_Right,    0,           Q_RIGHT_FOCUS},
   {XK_Left,     0,           Q_LEFT_FOCUS},
   {XK_Return,   0,           Q_ACTION}};

MenuElem* StartMenuItem = StartMenuTemplate;
MenuElem* CtrlMenuItem = CtrlMenuTemplate;
MenuElem* DesktopMenuItem = DesktopMenuTemplate;
MenuElem* IconMenuItem = IconMenuTemplate;
MenuElem* TaskbarMenuItem = TaskbarMenuTemplate;
MenuElem* ExitDlgItem = ExitDlgTemplate;
MenuElem* ShortCutItem = NULL;
SCKeyTable* scKey = NULL;
SCKeyTable* menuKey = NULL;

VariableTable varTable[] =
  {{"DoubleClickTime",		F_POSITIVE,	&DoubleClickTime},
   {"DoubleClickRange",		F_POSITIVE,	&DoubleClickRange},
   {"TitlebarMotion",		F_BOOL,		&TitlebarMotion},
   {"TitlebarMotionSpeed",	F_POSITIVE,	&TitlebarMotionSpeed},
   {"MenuDelayTime",		F_NATURAL,	&MenuDelayTime},
   {"MenuDelayTime2",		F_NATURAL,	&MenuDelayTime2},
   {"PagingMovement",		F_NATURAL, 	&PagingMovement},
   {"TopLeftPage",		F_OFFSET,	&TopLeftPage},
   {"PagingSize",		F_SIZE,		&PagingSize},
   {"PagingSpeed",		F_POSITIVE,	&PagingSpeed},
   {"PagerGeometry",		F_GEOMETRY,	&PagerGeometry},
   {"EdgeResistance",		F_NATURAL,	&EdgeResistance},
   {"SnappingMove",		F_NATURAL,	&SnappingMove},
   {"SnappingEdges",		F_NATURAL,	&SnappingEdges},
   {"NoResizeOverTaskbar",	F_BOOL,		&NoResizeOverTaskbar},
   {"SmartPlacement",		F_BOOL,		&SmartPlacement},
   {"UseTaskbar",		F_BOOL,		&UseTaskbar},
   {"TaskbarPosition",		F_TASKBAR,	&TaskbarPosition},
   {"TaskbarRows",		F_POSITIVE,	&TaskbarRows},
   {"OnTopTaskbar",		F_BOOL,		&OnTopTaskbar},
   {"AutoRaiseDelay",		F_NATURAL,	&AutoRaiseDelay},
   {"WallPaper",		F_STRING,	&WallPaper},
   {"LocaleName",		F_STRING,	&LocaleName},
   {"UseBoldFont",		F_BOOL,		&UseBoldFont},
   {"UseExitDialog",		F_BOOL,		&UseExitDialog},
   {"UseConfirmDialog",		F_BOOL,		&UseConfirmDialog},
   {"UsePager",			F_BOOL,		&UsePager},
   {"OpaqueMove",		F_BOOL,		&OpaqueMove},
   {"OpaqueResize",		F_BOOL,		&OpaqueResize},
   {"FullOpaque",		F_BOOL,		&FullOpaque},
   {"ClickToFocus",		F_BOOL,		&ClickToFocus},
   {"FocusOnMap",		F_BOOL,		&FocusOnMap},
   {"ClickingRaises",		F_BOOL,		&ClickingRaises},
   {"NoDesktopFocus",		F_BOOL,		&NoDesktopFocus},
   {"AutoRaise",		F_BOOL,		&AutoRaise},
   {"UseClock",			F_BOOL,		&UseClock},
   {"ClockLocaleName",		F_STRING,	&ClockLocaleName},
   {"ImagePath",		F_STRING,	&ImagePath},
   {"TaskbarAutoHide",		F_BOOL,		&TaskbarAutoHide},
   {"RestoreMinimize",		F_BOOL,		&RestoreMinimize},
   {"RestartOnFailure",		F_BOOL,		&RestartOnFailure},
   {"GradMenuMap",		F_BOOL,		&GradMenuMap},
   {"GradMenuMapSpeed",		F_POSITIVE,	&GradMenuMapSpeed},
   {"GradTaskbarMotion",	F_BOOL,		&GradTaskbarMotion},
   {"GradTaskbarMotionSpeed",	F_POSITIVE,	&GradTaskbarMotionSpeed},
   {"GradTitlebar",		F_BOOL,		&GradTitlebar},
   {"GradTitlebarColors",	F_POSITIVE,	&GradTitlebarColors},
   {"OnTopPager",               F_BOOL,         &OnTopPager},
   {"IconSize",			F_POSITIVE,	&IconSize},
   {"FrameTitleHeight",		F_POSITIVE,	&FrameTitleHeight},
   {"FrameBorderWidth",		F_POSITIVE,	&FrameBorderWidth},
   {"TaskbarButtonHeight",	F_POSITIVE,	&TaskbarButtonHeight},
   {"IndicatorSize",		F_POSITIVE,	&IndicatorSize},
   {"IconVerticalSpacing",	F_POSITIVE,	&IconVerticalSpacing},
   {"IconHorizontalSpacing",	F_POSITIVE,	&IconHorizontalSpacing},
   {"ShiftMoveRatio",		F_FLOATING,	&ShiftMoveRatio},
   {"CtrlMoveRatio",		F_FLOATING,	&CtrlMoveRatio},
   {"HourGlassTime",		F_NATURAL,	&HourGlassTime},
   {"UseInfoDisplay",		F_BOOL,		&UseInfoDisplay},
   {"GradWindowMapStyle",	F_GRADSTYLE,	&GradWindowMapStyle},
   {"GradWindowMapSpeed",	F_POSITIVE,	&GradWindowMapSpeed},
   {"UseDebugger",		F_BOOL,		&UseDebugger},
   {"TooltipDelayTime",		F_NATURAL,	&TooltipDelayTime},
   {"TooltipMotionSpeed",	F_POSITIVE,	&TooltipMotionSpeed},
   {"TooltipDisplayTime",	F_NATURAL,	&TooltipDisplayTime},
   {"NoFocusChangeMask",	F_MODMASK,	&NoFocusChangeMask},
   {"TaskbarShowDelay",		F_NATURAL,	&TaskbarShowDelay},
   {"TaskbarHideDelay",		F_NATURAL,	&TaskbarHideDelay},
   {"TaskbarButtonInScr",	F_BOOL,		&TaskbarButtonInScr},
   {"AllowRemoteCmd",		F_BOOL,		&AllowRemoteCmd},
   {"DisableDesktopChange",	F_BOOL,		&DisableDesktopChange},
   {"StartButtonTitle",		F_STRING,	&StartButtonTitle},
   {"StartButtonMessage",	F_STRING,	&StartButtonMessage},
   {"MinimizeButtonMessage",	F_STRING,	&MinimizeButtonMessage},
   {"MaximizeButtonMessage",	F_STRING,	&MaximizeButtonMessage},
   {"CloseButtonMessage",	F_STRING,	&CloseButtonMessage},
   {"RestoreButtonMessage",	F_STRING,	&RestoreButtonMessage},
   {"ClockFormat",		F_STRING,	&ClockFormat},
   {"ClockMessageFormat",	F_STRING,	&ClockMessageFormat},
   {"TitlebarImage",		F_STRING,	&TitlebarImage},
   {"TitlebarActiveImage",	F_STRING,	&TitlebarActiveImage},
   {"FrameImage",		F_STRING,	&FrameImage},
   {"FrameActiveImage",		F_STRING,	&FrameActiveImage},
   {"TaskbarImage",		F_STRING,	&TaskbarImage},
   {"MenuImage",		F_STRING,	&MenuImage},
   {"MenuActiveImage",		F_STRING,	&MenuActiveImage},
   {"PagerImage",		F_STRING,	&PagerImage},
   {"DialogImage",		F_STRING,	&DialogImage},
   {"SwitcherImage",		F_STRING,	&SwitcherImage},
   {"StartMenuLogoImage",	F_STRING,	&StartMenuLogoImage},
   {"DefaultIcon",		F_STRING,	&DefaultIcon},
   {"DefaultLargeIcon",		F_STRING,	&DefaultLargeIcon},
   {"DefaultShortcutIcon",	F_STRING,	&DefaultShortcutIcon},
   {"TitlebarColor",		F_COLOR,	&TitlebarColor},
   {"TitlebarColor2",		F_COLOR,	&TitlebarColor2},
   {"TitlebarActiveColor",	F_COLOR,	&TitlebarActiveColor},
   {"TitlebarActiveColor2",	F_COLOR,	&TitlebarActiveColor2},
   {"TitleStringColor",		F_COLOR,	&TitleStringColor},
   {"TitleStringActiveColor",	F_COLOR,	&TitleStringActiveColor},
   {"IconForeColor",		F_COLOR,	&IconForeColor},
   {"IconBackColor",		F_COLOR,	&IconBackColor},
   {"IconStringColor",		F_COLOR,	&IconStringColor},
   {"IconStringActiveColor",	F_COLOR,	&IconStringActiveColor},
   {"FrameColor",		F_COLOR,	&FrameColor},
   {"FrameActiveColor",		F_COLOR,	&FrameActiveColor},
   {"PagerColor",		F_COLOR,	&PagerColor},
   {"PagerActiveColor",		F_COLOR,	&PagerActiveColor},
   {"MiniatureColor",		F_COLOR,	&MiniatureColor},
   {"MiniatureActiveColor",	F_COLOR,	&MiniatureActiveColor},
   {"MenuColor",		F_COLOR,	&MenuColor},
   {"MenuActiveColor",		F_COLOR,	&MenuActiveColor},
   {"MenuStringColor",		F_COLOR,	&MenuStringColor},
   {"MenuStringActiveColor",	F_COLOR,	&MenuStringActiveColor},
   {"SwitcherColor",		F_COLOR,	&SwitcherColor},
   {"SwitcherActiveColor",	F_COLOR,	&SwitcherActiveColor},
   {"SwitcherStringColor",	F_COLOR,	&SwitcherStringColor},
   {"DialogColor",		F_COLOR,	&DialogColor},
   {"DialogStringColor",	F_COLOR,	&DialogStringColor},
   {"ButtonColor",		F_COLOR,	&ButtonColor},
   {"ButtonActiveColor",	F_COLOR,	&ButtonActiveColor},
   {"ButtonStringColor",	F_COLOR,	&ButtonStringColor},
   {"ButtonStringActiveColor",	F_COLOR,	&ButtonStringActiveColor},
   {"TaskbarColor",		F_COLOR,	&TaskbarColor},
   {"ClockStringColor",		F_COLOR,	&ClockStringColor},
   {"DesktopColor",		F_COLOR,	&DesktopColor},
   {"DesktopActiveColor",	F_COLOR,	&DesktopActiveColor},
   {"StartMenuLogoColor",	F_COLOR,	&StartMenuLogoColor},
   {"CursorColor",		F_COLOR,	&CursorColor},
   {"TooltipColor",		F_COLOR,	&TooltipColor},
   {"TooltipStringColor",	F_COLOR,	&TooltipStringColor},
   {"DefaultFont",		F_STRING,	&DefaultFont},
   {"TitleFont",		F_STRING,	&TitleFont},
   {"TaskbarFont",		F_STRING,	&TaskbarFont},
   {"TaskbarBoldFont",		F_STRING,	&TaskbarBoldFont},
   {"CascadeMenuFont",		F_STRING,	&CascadeMenuFont},
   {"CtrlMenuFont",		F_STRING,	&CtrlMenuFont},
   {"StartMenuFont",		F_STRING,	&StartMenuFont},
   {"IconFont",			F_STRING,	&IconFont},
   {"DialogFont",		F_STRING,	&DialogFont}
  };

/*
 * Table for fontset variable and font name.
 */
FsNameSet fsSet[] =
  {{&fsTitle,       &TitleFont},
   {&fsTaskbar,     &TaskbarFont},
   {&fsCascadeMenu, &CascadeMenuFont},
   {&fsCtrlMenu,    &CtrlMenuFont},
   {&fsStartMenu,   &StartMenuFont},
   {&fsIcon,        &IconFont},
   {&fsDialog,      &DialogFont},
   {&fsBoldTaskbar, &TaskbarBoldFont}};  // bold font must be the last entry

AttrNameSet attrSet[] =
  {{"STICKY",		STICKY,			True},
   {"NO_FOCUS",		NO_FOCUS,		True},
   {"NO_TITLE",		TITLE,			False},
   {"NO_BORDER",	BORDER | BORDER_EDGE,	False},
   {"NO_BORDER_EDGE",	BORDER_EDGE,		False},
   {"NO_TBUTTON",	NO_TBUTTON,		True},
   {"NO_CTRLBTN",	CTRL_MENU,		False},
   {"NO_BUTTON1",	BUTTON1,		False},
   {"NO_BUTTON2",	BUTTON2,		False},
   {"NO_BUTTON3",	BUTTON3,		False},
   {"SMALL_IMG",	SMALL_IMG,		True},
   {"LARGE_IMG",	LARGE_IMG,		True},
   {"CLOSE_SOON",	CLOSE_SOON,		True},
   {"ONTOP",		ONTOP,			True},
   {"INIT_MAXIMIZE",	INIT_MAXIMIZE,		True},
   {"INIT_MINIMIZE",	INIT_MINIMIZE,		True},
   {"FOCUS_ON_CLICK",	FOCUS_ON_CLICK,		True},
   {"GEOMETRY",		GEOMETRY,		True}
};

KeyMod keyMod[] =
  {{"Shift", ShiftMask},
   {"Ctrl",  ControlMask},
   {"Alt",   Mod1Mask},  // Mod1Mask is default
   {"Meta",  Mod1Mask},  // Mod1Mask is default
   {"Mod1",  Mod1Mask},
   {"Mod2",  Mod2Mask},
   {"Mod3",  Mod3Mask},
   {"Mod4",  Mod4Mask},
   {"Mod5",  Mod5Mask},
   {"None",  0}};

const int VarTableSize = sizeof(varTable) / sizeof(VariableTable);
const int FsNum = sizeof(fsSet) / sizeof(FsNameSet);
const int AttrNum = sizeof(attrSet) / sizeof(AttrNameSet);
const int KeyModNum = sizeof(keyMod) / sizeof(KeyMod);
const int MenuKeyNum = sizeof(scMenuKey) / sizeof(SCKeyEntry);
